#include <iostream>
#include <string>
#include <vector>

using namespace std;

typedef unsigned int uint;

inline uint bits (int p)
{
    return (1u << p) - 1;
}

inline uint get_bits (uint p, int start, int count)
{
    return (p & bits(start + count)) >> start;
}

inline uint get7bits (uint p, int of1, int of2, int of3)
{
    return get_bits(p, of1, 2) | (get_bits(p, of2, 3) << 2) | (get_bits(p, of3, 2) << 5);
}

inline uint get_bitnum (int n)
{
    switch (n)
    {
        case 0: return 4;
        case 1: return 5;
        case 2: return 8;
        case 3: return 9;
        case 4: return 10;
        case 5: return 13;
        case 6: return 14;
        default: return 0;
    }
}

inline uint get_pix7 (uint pix, int n)
{
    switch (n)
    {
        case 0: //0,1,3,4,5,8,9
            return get7bits(pix, 0, 3, 8);
        case 1: //1,2,4,5,6,9,10
            return get7bits(pix, 1, 4, 9);
        case 2: //3,4,7,8,9,12,13
            return get7bits(pix, 3, 7, 12);
        case 3: //4,5,8,9,10,13,14
            return get7bits(pix, 4, 8, 13);
        case 4: //5,6,9,10,11,14,15
            return get7bits(pix, 5, 9, 14);
        case 5: //8,9,12,13,14,16,17
            return get7bits(pix, 8, 12, 16);
        case 6: //9, 10, 13, 14, 15, 17, 18
            return get7bits(pix, 9, 13, 17);
        default: return 0;
    }
}

inline uint set_pixel (uint pix, int n)
{
    return pix | (1u << n);
}

inline uint clear_pixel (uint pix, int n)
{
    return pix & (~(1u << n));
}

inline uint pixels_transform (vector<bool>& filter, uint pixels)
{
    uint pix7, pixels_new = pixels;
    for (int j = 0; j < 7; j++)
    {
        pix7 = get_pix7 (pixels, j);
        if (filter[pix7])
            pixels_new = set_pixel(pixels_new, get_bitnum(j));
        else
            pixels_new = clear_pixel(pixels_new, get_bitnum(j));
    }
    return pixels_new;
}

void process_dataset (string& input)
{
    vector<bool> filter (128);
    for (int i = 0; i < 128; i++)
        filter[i] = input[i] == '1' ? true : false;

    uint lim = 1u << 19;
    uint trans;// = pixels_transform(filter, 1u);
    for (uint pix = 0; pix < lim; pix++)
    {
        trans = pixels_transform(filter, pix);
        if (trans != pixels_transform(filter, trans))
        {
            cout << "no" << endl;
            return;
        }
    }
    cout << "yes" << endl;
}

int main()
{
    string input;
    while (true)
    {
        cin >> input;
        if (input[0] == '#')
            return 0;
        process_dataset (input);
    }
}
